/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render.infobar;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.toma.gunsrpg.client.render.infobar.DataSourcedElement;
import dev.toma.gunsrpg.common.quests.quest.AbstractAreaBasedQuest;
import dev.toma.gunsrpg.util.RenderUtils;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class AreaDistanceElement<T extends AbstractAreaBasedQuest<?>>
extends DataSourcedElement<T> {
    private final ITextComponent title;
    private final Function<T, ITextComponent> distanceFunction;
    private final Function<T, BlockPos> centerGetter;
    private int width;

    public AreaDistanceElement(T dataSource, ITextComponent title, Function<T, ITextComponent> distanceFunction, Function<T, BlockPos> centerGetter) {
        super(dataSource);
        this.title = title;
        this.distanceFunction = distanceFunction;
        this.centerGetter = centerGetter;
    }

    @Override
    public void draw(MatrixStack matrix, FontRenderer font, int x, int y, int width, int height) {
        this.calculateDimensions(font);
        font.func_243248_b(matrix, this.title, (float)x, (float)y, 0xFFFFFF);
        AbstractAreaBasedQuest src = (AbstractAreaBasedQuest)this.getDataSource();
        ITextComponent col2 = this.distanceFunction.apply(src);
        int col2Width = font.func_238414_a_((ITextProperties)col2);
        font.func_243248_b(matrix, col2, (float)(x + width - col2Width - 16), (float)y, 0xFFFFFF);
        int compassLeft = x + width - 13;
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        RenderUtils.drawSolid(pose, compassLeft, y - 1, compassLeft + 10, y + 9, 0x66000000);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockPos center = this.centerGetter.apply(src);
        double orientation = this.getAngleTo(Vector3d.func_237489_a_((Vector3i)center), (Entity)player) / (Math.PI * 2);
        double playerOrientation = MathHelper.func_191273_b((double)((double)player.field_70177_z / 360.0), (double)1.0);
        float result = MathHelper.func_188207_b((float)((float)(0.5 - (playerOrientation - 0.25 - orientation))), (float)1.0f);
        float rotation = (float)((double)(result * 2.0f) * Math.PI);
        float sin = MathHelper.func_76126_a((float)rotation);
        float cos = MathHelper.func_76134_b((float)rotation);
        RenderSystem.lineWidth((float)1.0f);
        RenderUtils.drawLine(pose, compassLeft + 5, y, compassLeft + 5, y + 8, -7829368);
        RenderUtils.drawLine(pose, compassLeft + 1, y + 4, compassLeft + 9, y + 4, -7829368);
        RenderSystem.lineWidth((float)3.0f);
        RenderUtils.drawLine(pose, (float)compassLeft + 5.0f, (float)y + 4.0f, (float)compassLeft + 5.0f + 3.0f * sin, (float)y + 4.0f + 3.0f * -cos, -65536, -65536);
        RenderUtils.drawLine(pose, (float)compassLeft + 5.0f, (float)y + 4.0f, (float)compassLeft + 5.0f + 3.0f * -sin, (float)y + 4.0f + 3.0f * cos, -13399809, -13399809);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    private void calculateDimensions(FontRenderer font) {
        AbstractAreaBasedQuest source = (AbstractAreaBasedQuest)this.getDataSource();
        ITextComponent column2 = this.distanceFunction.apply(source);
        int leftWidth = font.func_238414_a_((ITextProperties)this.title);
        int spacing = 28;
        int rightWidth = font.func_238414_a_((ITextProperties)column2);
        this.width = leftWidth + spacing + rightWidth;
    }

    private double getAngleTo(Vector3d vector, Entity entity) {
        return Math.atan2(vector.func_82616_c() - entity.func_226281_cx_(), vector.func_82615_a() - entity.func_226277_ct_());
    }
}

